---
name: Bug report
about: Report an issue or unexpected behaviour with Plyr
---

<!--

Before creating the issue, please make sure that...

* You aren't getting any errors in your own code, causing the problem.
* You are using the latest version of Plyr.
* There isn't already an open issue for your problem.
* You are following the documentation correctly (https://github.com/sampotts/plyr/)
* Your problem doesn't happen if you remove Plyr and use native HTML5 media (when applicable).

For problems with autoplay, see our FAQ (https://github.com/sampotts/plyr/wiki/FAQ)

If you have multiple unrelated problems, create separate issues rather than combining them into one.

Note that leaving sections blank or being vague will make it difficult for us to troubleshoot and we may close the issue.
-->

### Expected behaviour

### Actual behaviour

### Steps to reproduce

### Environment

- Browser:
- Version:
- Operating System:
- Version:

### Console errors (if any)

### Link to where the bug is happening

<!--
This link can be either to our demo at https://plyr.io/ if the problem can be observed there, or to a code playground with a **minimal** test case that demonstrates the problem.

You can use one of our prepared templates to get started creating the test case:

* HTML5 video: https://codepen.io/pen?template=bKeqpr
* HTML5 audio: https://codepen.io/pen?template=rKLywR
* YouTube: https://codepen.io/pen?template=GGqbbJ
* Vimeo: https://codepen.io/pen?template=bKeXNq
* Dash.js integration: https://codepen.io/pen?template=zaBgBy
* Hls.js integration: https://codepen.io/pen?template=oyLKQb
* Shaka Player integration: https://codepen.io/pen?template=ZRpzZO

It's important that you keep the issue description and replication demo **minimal**. If your replication includes frameworks, libraries or customizations, this makes it much harder to understand the problem and find the bug. For more help on how to create the demo, see https://github.com/sampotts/plyr/wiki/Writing-helpful-issue-descriptions

-->
